(function(_window) {
    'use strict';

    var WSSID                                 = '{{WSSID}}';
    var LINK_ENHANCR_URL_PATH                 = '/v1/lucy?url=';
    var LINK_ENHANCR_END_POINT_PROD           = 'https://mobile.mail.yahoo.com';
    var LINK_ENHANCR_TAG                      = 'lEnhancr';
    var LINK_ENHANCR_ATTACHMENT_TYPE_INLINE   = "LINK_ENHANCR_ATTACHMENT_TYPE_INLINE";
    var LINK_ENHANCR_ATTACHMENT_TYPE_APPENDED = "LINK_ENHANCR_ATTACHMENT_TYPE_OUTLINE";

    var CLASS_PRIMARY_IMAGE_CELL       = "card-primary-image-cell";
    var CLASS_LINK_ENHANCR_NO_IMG      = "yahoo-link-enhancr-no-image";
    var CLASS_LINK_ENHANCR_CARD_APPEND = "yahoo-link-enhancr-cardSize-append";

    //This will hold preview link to its fetched json object,
    //this is to switch between two preview card very quickly.
    var PreviewLinkAnchorIdToJsonObj = {};

    /**
    * parse linkenhancr response json.
    * Returns null if any of the required values in null or not retrievable, otherwise returns map with title and image url
    * @private
    */
    function parseResponse(jsonResponse) {
        if (!jsonResponse) {
            return null;
        }
        try {
            var graphFirst,imageUrl400x200,linkTitle, imageUrl80x80;

            if (!jsonResponse["@graph"] || jsonResponse["@graph"].length === 0) {
                return null;
            }
            graphFirst = jsonResponse["@graph"][0];
            if (!graphFirst || !graphFirst.docproc || !graphFirst.docproc.linkinfo || !graphFirst.docproc.linkinfo.image || !graphFirst.docproc.linkinfo.title) {
                return null;
            }
            imageUrl400x200 = graphFirst.docproc.linkinfo.image.simage400x200;
            imageUrl80x80 = graphFirst.docproc.linkinfo.image.simage80x80;
            linkTitle = graphFirst.docproc.linkinfo.title;
            return {
                imageUrl400x200 : imageUrl400x200,
                imageUrl80x80 : imageUrl80x80,
                primaryImage: imageUrl400x200,
                primaryImageSection:true,
                cardTitle: linkTitle,
                url : graphFirst.requestedurl,
                cardDescription : graphFirst.docproc.linkinfo.description,
                cardType : "yenhancr",
                richInfoText1 : !graphFirst.docproc.linkinfo.author ? "" : graphFirst.docproc.linkinfo.author.name

            };
        } catch(err) {
            yMailBridge.logHandledException("In Compose/Link Enhancr : " + err.toString());
        }
        return null;
    }

    /**
    * @private
    */
    function fetchAndSetLinkEnhancr(urlParam, callback) {
         var linkEnhancrUrlWithParam, xmlHttpRequest,jsonBody,newWssid;
         linkEnhancrUrlWithParam = LINK_ENHANCR_END_POINT_PROD + LINK_ENHANCR_URL_PATH + encodeURIComponent(urlParam) + '&appname=mailenhancr';

         xmlHttpRequest = new XMLHttpRequest();
         xmlHttpRequest.onreadystatechange = function() {
              if(xmlHttpRequest.status === HTTP_ERROR) {
                   try {
                        jsonBody = JSON.parse(xmlHttpRequest.responseText);
                        newWssid = jsonBody.error.details.wssid;
                        if (newWssid) {
                            // Retry if we get new wssid
                            WSSID = newWssid;
                            fetchAndSetLinkEnhancr(urlParam, callback);
                            return;
                        }
                    } catch(err) {
                        yMailBridge.logHandledException("In Compose/Link Enhancr : " + err.toString());
                    }

              } else if (xmlHttpRequest.readyState === XHR_READY_STATE_DONE && xmlHttpRequest.status === HTTP_SUCCESS) {
                    callback(JSON.parse(xmlHttpRequest.responseText));
              }
         };

         xmlHttpRequest.open("GET", linkEnhancrUrlWithParam, true); // true for asynchronous
         xmlHttpRequest.send(null);
    }

    /**
    * @private
    */
    function getCardElement(cardData, templatePath) {
         if (!templatePath) {
             templatePath = TEMPLATE_RES.card_medium;
         }

         return createCardElement(templatePath, cardData, true);
    }

    /**
    * @private
    */
    function createCardElement(templatePath, cardData, fullyTappable) {

         var cardElement, moreButton;

         cardData.cardId = LINK_ENHANCR_TAG + "_" + Date.now();
         cardElement = Template.loadTemplate(templatePath, cardData);
         moreButton = LinkEnhancr.getMoreButton(cardData.cardId);

         if (moreButton) {
             cardElement.appendChild(moreButton);
         }

         cardElement.setAttribute("data-type", (cardElement.getAttribute("data-size") === "append") ? LINK_ENHANCR_ATTACHMENT_TYPE_APPENDED: LINK_ENHANCR_ATTACHMENT_TYPE_INLINE);
         cardElement.setAttribute('contenteditable', 'false');
         cardElement.style.position='relative';

         if (!cardElement.querySelector("[class*='" + CLASS_PRIMARY_IMAGE_CELL + "']")) {
             cardElement.classList.add(CLASS_LINK_ENHANCR_NO_IMG);
         }

         return cardElement;
    }

    /**
    * @private
    */
    function createCardPreviewElement(title) {
         return Template.loadTemplate(TEMPLATE_RES.card_preview, {
              title: title
         });
    }

    var LinkEnhancr = {

    /**
    * Creates more button with it's click handler
    * @param cardId - cardId to be associated with
    */
    getMoreButton: function(cardId) {
         var moreButton = document.createElement("button");
         moreButton.className = CLASS_LINK_ENHANCR_MORE_BUTTON;
         moreButton.contentEditable = false;
         moreButton.setAttribute("data-guid", cardId);
         moreButton.setAttribute("data-action", "moreMenuInlineAttachment");
         moreButton.name = "showInlineImageMenu";
         moreButton.setAttribute("aria-label", "more menu");
         moreButton.setAttribute('style', 'top: 8px; right: 8px; position: absolute; border: none;' +
                    'background: url("https://com.yahoo.mobile.client.android.mail.resource/drawable/mailsdk_compose_collapse_inline") no-repeat 0 0;background-size: 100%; width: 30px; height:30px;');
         moreButton.addEventListener('click', LinkEnhancr.handleMoreButtonOnClick, false);
         return moreButton;
    },

   /**
    * For passed in url and corresponding link anchor id, this will fetch the link preview info and
    * creates amd sets the preview card (medium size)
    * @param urlParam String url for which we want to show preview
    * @param anchorId id of the anchor-link to map with the preview card
    */
    fetchAndSetLinkEnhancr : function(urlParam, anchorId) {
         if(!urlParam || !anchorId || PreviewLinkAnchorIdToJsonObj[anchorId]) {
            return;
         }

         lucyBridge.fetchLinkEnhancrCard(urlParam, anchorId);
    },

     handleMoreButtonOnClick : function(event) {
         var cardId, showMoveToInline;
         cardId = event.target.getAttribute("data-guid");
         showMoveToInline = event.target.parentNode.getAttribute('data-size') === 'append';
         yMailBridge.showLinkEnhancerOption(cardId, showMoveToInline);
     },

    /**
     * Move the link preview card to inline below it's anchor
     * @param cardId previewCard Id to be moved
     */
     moveLinkPreviewToInline : function(cardId) {

         var cardToRemove, anchorElement, linkForTheCard, cardParent, previewsContainer, linkCardAppend, cardElement, cardAnchor, jsonForLinkId;
         cardToRemove = document.getElementById(cardId);
         if (!cardToRemove) {
            return;
         }
         anchorElement = document.querySelector("[class*='" + cardId + "']");
         if (!anchorElement) {
             //if we can't find anchor id, means the card has been created somewhere else and came from server)
             //in that event, we can't do much
             return;
         }
         //This will be null in case we are opening draft message
         if (!PreviewLinkAnchorIdToJsonObj[anchorElement.id]) {
             fetchAndSetLinkEnhancr(anchorElement.href, function(jsonObj) {
                    var responseObj = parseResponse(jsonObj);
                    if (!responseObj || !responseObj.primaryImage || !responseObj.cardTitle) {
                        return;
                    }
                    PreviewLinkAnchorIdToJsonObj[anchorElement.id] = responseObj;
                    moveLinkPreviewToInline(cardId);
                 });
             return;
         }
         cardParent = cardToRemove.parentNode;
         cardParent.removeChild(cardToRemove);

         previewsContainer = document.querySelector("[class*='" + CLASS_LINK_ENHANCR_PREVIEWS + "']");
         if (previewsContainer) {
             linkCardAppend = previewsContainer.querySelector("[class*='" + CLASS_LINK_ENHANCR_CARD_APPEND + "']");
             if (!linkCardAppend) {
                previewsContainer.remove();
             }
         }
         jsonForLinkId = PreviewLinkAnchorIdToJsonObj[anchorElement.id];
         jsonForLinkId.primaryImage = jsonForLinkId.imageUrl400x200;
         cardElement = getCardElement(jsonForLinkId, TEMPLATE_RES.card_medium);
         anchorElement.className = cardElement.id;
         cardParent.appendChild(cardElement);
         anchorElement.parentNode.insertBefore(cardElement, anchorElement.nextSibling);

         syncComposeContent(document.getElementById(COMPOSE_CONTENT_ELEMENT_ID));
     },


     /**
     * Move the link preview card to bottom
     * @param cardId previewCard Id to be moved
     */
     moveLinkPreviewToBottom : function (cardId) {
         var cardToRemove, anchorElement, previewsContainer, linkForTheCard, cardParent, cardElement, jsonForLinkId;
         cardToRemove = document.getElementById(cardId);
         if (!cardToRemove) {
            return;
         }

         anchorElement = document.querySelector("[class*='" + cardId + "']");
         if (!anchorElement) {
            //if we can't find anchor id, means the card has been created somewhere else and came from server)
            //in that event, we can't do much
            return;
         }
         previewsContainer = document.querySelector("[class*='" + CLASS_LINK_ENHANCR_PREVIEWS + "']");
         //This will be null in case we are opening draft message
         if (!PreviewLinkAnchorIdToJsonObj[anchorElement.id]) {
              fetchAndSetLinkEnhancr(anchorElement.href, function(jsonObj) {
                    var responseObj = parseResponse(jsonObj);
                    if (!responseObj || !responseObj.primaryImage || !responseObj.cardTitle) {
                        return;
                    }
                    PreviewLinkAnchorIdToJsonObj[anchorElement.id] = responseObj;
                    moveLinkPreviewToBottom(cardId);
              });
              return;
         }
         cardParent = cardToRemove.parentNode;
         cardParent.removeChild(cardToRemove);

         jsonForLinkId = PreviewLinkAnchorIdToJsonObj[anchorElement.id];
         jsonForLinkId.primaryImage = jsonForLinkId.imageUrl80x80;
         cardElement = getCardElement(jsonForLinkId, TEMPLATE_RES.card_append);
         anchorElement.className = cardElement.id;

         if (!previewsContainer) {
            previewsContainer = createCardPreviewElement(yMailBridge.getLinkPreviewLabel());
            //If stationery is enabled, we want to be inside stationery element, otherwise in the compose_content
            if (Stationery.containsStationery()) {
                cardParent = document.getElementById(STATIONERY_BODY_ID);
            } else {
                cardParent = document.getElementById(COMPOSE_CONTENT_ELEMENT_ID);
            }
            cardParent.appendChild(previewsContainer);
         }
         previewsContainer.appendChild(cardElement);
         syncComposeContent(document.getElementById(COMPOSE_CONTENT_ELEMENT_ID));
     },

     /**
     * Remove the link preview card and changes the anchor text from title to link
     * @param cardId previewCard Id to be removed
     */
     removeLinkPreview : function (cardId) {
         //Remove card
         var cardToRemove, anchorElement, previewsContainer, linkCardAppend, previewAnchor;
         cardToRemove = document.getElementById(cardId);
         if (!cardToRemove) {
             return;
         }
         anchorElement = document.querySelector("[class*='" + cardId + "']");
         cardToRemove.remove();

         previewsContainer = document.querySelector("[class*='" + CLASS_LINK_ENHANCR_PREVIEWS + "']");
         if (previewsContainer) {
             linkCardAppend = previewsContainer.querySelector("[class*='" + CLASS_LINK_ENHANCR_CARD_APPEND + "']");
             if (!linkCardAppend) {
                 previewsContainer.remove();
             }
         }

         //Change the anchor text
         if (anchorElement) {
            anchorElement.innerHTML = anchorElement.href;
         }

         syncComposeContent(document.getElementById(COMPOSE_CONTENT_ELEMENT_ID));

         //Clear from map
         delete PreviewLinkAnchorIdToJsonObj[anchorElement.id];
     },

     handleLinkEnhancrResponse: function (jsonObj, anchorId) {
        var responseObj, cardElement, anchorElement;
        anchorElement = document.getElementById(anchorId);
        responseObj = parseResponse(JSON.parse(JSON.stringify(jsonObj)));

        if (!anchorElement || PreviewLinkAnchorIdToJsonObj[anchorId] || !responseObj || !responseObj.primaryImage || !responseObj.cardTitle) {
          return;
        }

        cardElement = getCardElement(responseObj, TEMPLATE_RES.card_medium);
        anchorElement.className = cardElement.id;
        anchorElement.parentNode.insertBefore(cardElement, anchorElement.nextSibling);
        syncComposeContent(document.getElementById(COMPOSE_CONTENT_ELEMENT_ID));
        PreviewLinkAnchorIdToJsonObj[anchorId] = responseObj;

        //Update the anchor inner text with the preview data title
        anchorElement.innerHTML = responseObj.cardTitle;
     },
};
_window.LinkEnhancr = LinkEnhancr;
})(window);